/*
 * Decompiled with CFR 0.152.
 */
package com.aetherteam.aether.client.gui.screen.perks;

import com.aetherteam.aether.attachment.AetherDataAttachments;
import com.aetherteam.aether.attachment.AetherPlayerAttachment;
import com.aetherteam.aether.client.gui.component.skins.ChangeSkinButton;
import com.aetherteam.aether.client.gui.component.skins.PatreonButton;
import com.aetherteam.aether.client.gui.component.skins.RefreshButton;
import com.aetherteam.aether.data.resources.registries.AetherMoaTypes;
import com.aetherteam.aether.entity.AetherEntityTypes;
import com.aetherteam.aether.entity.passive.Moa;
import com.aetherteam.aether.network.packet.serverbound.ServerMoaSkinPacket;
import com.aetherteam.aether.perk.CustomizationsOptions;
import com.aetherteam.aether.perk.data.ClientMoaSkinPerkData;
import com.aetherteam.aether.perk.types.MoaData;
import com.aetherteam.aether.perk.types.MoaSkins;
import com.aetherteam.aetherfabric.network.PacketDistributor;
import com.aetherteam.nitrogen.api.users.User;
import com.aetherteam.nitrogen.api.users.UserData;
import com.aetherteam.nitrogen.network.packet.serverbound.TriggerUpdateInfoPacket;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import net.minecraft.class_124;
import net.minecraft.class_1309;
import net.minecraft.class_156;
import net.minecraft.class_1937;
import net.minecraft.class_2477;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2960;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_364;
import net.minecraft.class_407;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_490;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import net.minecraft.class_5481;
import net.minecraft.class_7919;
import net.minecraft.class_8666;
import net.minecraft.class_8710;
import org.jetbrains.annotations.Nullable;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;

public class MoaSkinsScreen
extends class_437 {
    public static final class_2960 MOA_SKINS_GUI = class_2960.method_60655((String)"aether", (String)"textures/gui/perks/skins/skins.png");
    public static final class_2960 LOCK_SPRITE = class_2960.method_60655((String)"aether", (String)"skins/lock");
    public static final class_2960 SLOT_SELECTED_SPRITE = class_2960.method_60655((String)"aether", (String)"skins/slot_selected");
    public static final class_8666 SLOT_WIDGET = new class_8666(class_2960.method_60655((String)"aether", (String)"skins/slot"), class_2960.method_60655((String)"aether", (String)"skins/slot_disabled"), class_2960.method_60655((String)"aether", (String)"skins/slot_highlighted"));
    public static final class_8666 SCROLL_WIDGET = new class_8666(class_2960.method_60655((String)"aether", (String)"skins/scroll"), class_2960.method_60655((String)"aether", (String)"skins/scroll_disabled"), class_2960.method_60655((String)"aether", (String)"skins/scroll"));
    public static final class_8666 PERMANENT_WIDGET = new class_8666(class_2960.method_60655((String)"aether", (String)"skins/permanent"), class_2960.method_60655((String)"aether", (String)"skins/permanent_highlighted"));
    public static final class_8666 TEMPORARY_WIDGET = new class_8666(class_2960.method_60655((String)"aether", (String)"skins/temporary"), class_2960.method_60655((String)"aether", (String)"skins/temporary_highlighted"));
    private static final String PATREON_LINK = "https://www.patreon.com/TheAetherTeam";
    private static final String HELP_LINK = "https://github.com/The-Aether-Team/.github/wiki/Patreon-Guide";
    private final class_437 lastScreen;
    private final int imageWidth = 176;
    private final int imageHeight = 184;
    private int leftPos;
    private int topPos;
    private final CustomizationsOptions customizations = CustomizationsOptions.INSTANCE;
    private List<MoaSkins.MoaSkin> moaSkins;
    private List<Float> snapPoints;
    private MoaSkins.MoaSkin selectedSkin;
    private ChangeSkinButton applyButton;
    private ChangeSkinButton removeButton;
    private boolean scrolling;
    private float scrollX;
    private float moaRotation = 0.0f;
    private Moa previewMoa;
    private boolean userConnectionExists = false;

    public MoaSkinsScreen(class_437 lastScreen) {
        super((class_2561)class_2561.method_43471((String)"gui.aether.moa_skins.title"));
        this.lastScreen = lastScreen;
    }

    public void method_25426() {
        this.leftPos = (this.field_22789 - this.imageWidth) / 2;
        this.topPos = (this.field_22790 - this.imageHeight) / 2;
        User user = UserData.Client.getClientUser();
        this.userConnectionExists = user != null;
        this.moaSkins = List.copyOf(MoaSkins.getMoaSkins().values());
        this.snapPoints = new ArrayList<Float>();
        int remainingSlots = this.moaSkins.size() - this.maxSlots();
        for (int i = 0; i <= remainingSlots; ++i) {
            this.snapPoints.add(Float.valueOf(this.scrollbarGutterWidth() / (float)remainingSlots * (float)i));
        }
        if (this.aetherFabric$getMinecraft().field_1724 != null) {
            UUID uuid = this.aetherFabric$getMinecraft().field_1724.method_5667();
            Map userSkinsData = ClientMoaSkinPerkData.INSTANCE.getClientPerkData();
            if (this.getSelectedSkin() == null) {
                this.selectedSkin = userSkinsData.containsKey(uuid) ? ((MoaData)userSkinsData.get(uuid)).moaSkin() : this.moaSkins.getFirst();
            }
            this.applyButton = (ChangeSkinButton)this.method_37063((class_364)new ChangeSkinButton(ChangeSkinButton.ButtonType.APPLY, class_4185.method_46430((class_2561)class_2561.method_43471((String)"gui.aether.moa_skins.button.apply"), pressed -> {
                PacketDistributor.sendToServer(new ServerMoaSkinPacket.Apply(this.aetherFabric$getMinecraft().field_1724.method_5667(), new MoaData(((AetherPlayerAttachment)this.aetherFabric$getMinecraft().field_1724.getAttachedOrCreate(AetherDataAttachments.AETHER_PLAYER)).getLastRiddenMoa(), this.getSelectedSkin())), new class_8710[0]);
                this.customizations.setMoaSkin(this.getSelectedSkin().getId());
                this.customizations.save();
                this.customizations.load();
            }).method_46434(this.leftPos + this.imageWidth - 20, this.topPos + 13, 7, 7)));
            this.removeButton = (ChangeSkinButton)this.method_37063((class_364)new ChangeSkinButton(ChangeSkinButton.ButtonType.REMOVE, class_4185.method_46430((class_2561)class_2561.method_43471((String)"gui.aether.moa_skins.button.remove"), pressed -> {
                PacketDistributor.sendToServer(new ServerMoaSkinPacket.Remove(this.aetherFabric$getMinecraft().field_1724.method_5667()), new class_8710[0]);
                this.customizations.setMoaSkin("");
                this.customizations.save();
                this.customizations.load();
            }).method_46434(this.leftPos + this.imageWidth - 20, this.topPos + 22, 7, 7)));
            this.method_37063((class_364)new RefreshButton(class_4185.method_46430((class_2561)class_2561.method_43470((String)""), pressed -> {
                if (RefreshButton.reboundTimer == 0) {
                    PacketDistributor.sendToServer((class_8710)new TriggerUpdateInfoPacket(this.aetherFabric$getMinecraft().field_1724.method_5628()), new class_8710[0]);
                    RefreshButton.reboundTimer = 1200;
                }
            }).method_46434(this.leftPos + 7, this.topPos + this.imageHeight - 25, 18, 18).method_46436(class_7919.method_47407((class_2561)class_2561.method_43471((String)"gui.aether.moa_skins.button.refresh")))));
            this.method_37063((class_364)new PatreonButton(class_4185.method_46430((class_2561)class_2561.method_43471((String)"gui.aether.moa_skins.button.donate"), pressed -> this.aetherFabric$getMinecraft().method_1507((class_437)new class_407(callback -> {
                if (callback) {
                    class_156.method_668().method_670(PATREON_LINK);
                }
                this.aetherFabric$getMinecraft().method_1507((class_437)this);
            }, PATREON_LINK, true))).method_46434(this.leftPos + this.imageWidth / 2 - 27, this.topPos + this.imageHeight - 25, 54, 18)));
            this.method_37063((class_364)new PatreonButton(class_4185.method_46430((class_2561)class_2561.method_43470((String)"?"), pressed -> this.aetherFabric$getMinecraft().method_1507((class_437)new class_407(callback -> {
                if (callback) {
                    class_156.method_668().method_670(HELP_LINK);
                }
                this.aetherFabric$getMinecraft().method_1507((class_437)this);
            }, HELP_LINK, true))).method_46434(this.leftPos + this.imageWidth / 2 + 63, this.topPos + this.imageHeight - 25, 18, 18).method_46436(class_7919.method_47407((class_2561)class_2561.method_43471((String)"gui.aether.moa_skins.button.help"))), true));
        }
    }

    public void method_25394(class_332 guiGraphics, int mouseX, int mouseY, float partialTicks) {
        super.method_25394(guiGraphics, mouseX, mouseY, partialTicks);
        this.checkUserConnectionStatus();
    }

    public void method_25420(class_332 guiGraphics, int mouseX, int mouseY, float partialTicks) {
        this.method_52752(guiGraphics);
        this.renderWindow(guiGraphics);
        this.renderSlots(guiGraphics, mouseX, mouseY);
        this.renderInterface(guiGraphics, mouseX, mouseY, partialTicks);
    }

    private void renderWindow(class_332 guiGraphics) {
        User user = UserData.Client.getClientUser();
        class_327 font = this.aetherFabric$getMinecraft().field_1772;
        guiGraphics.method_25302(MOA_SKINS_GUI, this.leftPos, this.topPos, 0, 0, this.imageWidth, this.imageHeight);
        class_5250 component = user == null ? class_2561.method_43471((String)"gui.aether.moa_skins.text.donate") : class_2561.method_43471((String)"gui.aether.moa_skins.text.reward");
        int y = this.topPos + this.imageHeight - 69 + font.method_44378((class_5348)component, this.imageWidth - 20);
        for (class_5481 sequence : font.method_1728((class_5348)component, this.imageWidth - 20)) {
            guiGraphics.method_35719(font, sequence, this.leftPos + this.imageWidth / 2, y, 0xFFFFFF);
            y += 12;
        }
    }

    private void renderSlots(class_332 guiGraphics, int mouseX, int mouseY) {
        if (this.aetherFabric$getMinecraft().field_1724 != null) {
            UUID uuid = this.aetherFabric$getMinecraft().field_1724.method_5667();
            Map userSkinsData = ClientMoaSkinPerkData.INSTANCE.getClientPerkData();
            User user = UserData.Client.getClientUser();
            List<MoaSkins.MoaSkin> visibleSkins = this.moaSkins.size() > this.maxSlots() ? this.moaSkins.subList(this.getSlotOffset(), this.getSlotOffset() + this.maxSlots()) : this.moaSkins;
            int slotIndex = 0;
            for (MoaSkins.MoaSkin skin : visibleSkins) {
                int x = this.leftPos + 7 + slotIndex * 18;
                int y = this.topPos + this.imageHeight / 2 + 9;
                if (user == null || !skin.getUserPredicate().test(user) || skin == this.getSelectedSkin() || this.getSlotIndex(mouseX, mouseY) == slotIndex) {
                    class_2960 location = SLOT_WIDGET.method_52729(user != null && skin.getUserPredicate().test(user), skin == this.getSelectedSkin() || this.getSlotIndex(mouseX, mouseY) == slotIndex);
                    guiGraphics.method_52706(location, x, y, 18, 18);
                }
                if (userSkinsData.containsKey(uuid) && ((MoaData)userSkinsData.get(uuid)).moaSkin() == skin) {
                    guiGraphics.method_52706(SLOT_SELECTED_SPRITE, x, y, 18, 18);
                }
                guiGraphics.method_52706(skin.getIconLocation(), x + 1, y + 1, 16, 16);
                ++slotIndex;
            }
        }
        this.renderScrollbar(guiGraphics);
        this.renderSlotTooltips(guiGraphics, mouseX, mouseY);
    }

    private void renderScrollbar(class_332 guiGraphics) {
        int scrollbarTop = this.topPos + this.imageHeight / 2 + 29;
        int scrollbarLeft = this.leftPos + 8;
        class_2960 location = SCROLL_WIDGET.method_52729(this.moaSkins.size() > this.maxSlots(), true);
        guiGraphics.method_52706(location, (int)((float)scrollbarLeft + this.scrollX), scrollbarTop, 13, 6);
    }

    private void renderSlotTooltips(class_332 guiGraphics, double mouseX, double mouseY) {
        MoaSkins.MoaSkin skin = this.getSkinFromSlot(mouseX, mouseY);
        if (skin != null) {
            class_2561 name = skin.getDisplayName();
            guiGraphics.method_51438(this.aetherFabric$getMinecraft().field_1772, name, (int)mouseX, (int)mouseY);
        }
    }

    private void renderInterface(class_332 guiGraphics, int mouseX, int mouseY, float partialTicks) {
        User user = UserData.Client.getClientUser();
        if (user != null && this.getSelectedSkin().getUserPredicate().test(user)) {
            this.applyButton.field_22763 = true;
            this.removeButton.field_22763 = true;
            if (this.getSelectedSkin().getInfo().lifetime() || user.getCurrentTier() == null || user.getCurrentTierLevel() < this.getSelectedSkin().getInfo().tier().getLevel()) {
                boolean mouseOver = this.isMouseOverIcon(mouseX, mouseY, 8);
                this.renderLifetimeIcon(guiGraphics, mouseOver);
                if (mouseOver) {
                    this.renderTooltip(class_2561.method_43471((String)"gui.aether.moa_skins.tooltip.title.access.lifetime"), (class_2561)class_2561.method_43471((String)"gui.aether.moa_skins.tooltip.lifetime"), guiGraphics, mouseX, mouseY);
                }
            } else if (user.getCurrentTier() != null) {
                boolean mouseOver = this.isMouseOverIcon(mouseX, mouseY, 7);
                this.renderPledgingIcon(guiGraphics, mouseOver);
                if (mouseOver) {
                    this.renderTooltip(class_2561.method_43471((String)"gui.aether.moa_skins.tooltip.title.access.pledging"), (class_2561)class_2561.method_43469((String)"gui.aether.moa_skins.tooltip.pledging", (Object[])new Object[]{user.getCurrentTier().getDisplayName()}), guiGraphics, mouseX, mouseY);
                }
            }
        } else {
            this.applyButton.field_22763 = false;
            this.removeButton.field_22763 = false;
            guiGraphics.method_52706(LOCK_SPRITE, this.leftPos + 13, this.topPos + 13, 10, 14);
            if (this.getSelectedSkin().getInfo().lifetime()) {
                boolean mouseOver = this.isMouseOverIcon(mouseX, mouseY, 8);
                this.renderLifetimeIcon(guiGraphics, mouseOver);
                if (mouseOver) {
                    this.renderTooltip(class_2561.method_43471((String)"gui.aether.moa_skins.tooltip.title.access.lifetime"), (class_2561)class_2561.method_43469((String)"gui.aether.moa_skins.tooltip.access.lifetime", (Object[])new Object[]{this.getSelectedSkin().getInfo().tier().getDisplayName()}), guiGraphics, mouseX, mouseY);
                }
            } else {
                boolean mouseOver = this.isMouseOverIcon(mouseX, mouseY, 7);
                this.renderPledgingIcon(guiGraphics, mouseOver);
                if (mouseOver) {
                    this.renderTooltip(class_2561.method_43471((String)"gui.aether.moa_skins.tooltip.title.access.pledging"), (class_2561)class_2561.method_43469((String)"gui.aether.moa_skins.tooltip.access.pledging", (Object[])new Object[]{this.getSelectedSkin().getInfo().tier().getDisplayName()}), guiGraphics, mouseX, mouseY);
                }
            }
        }
        this.renderMoa(guiGraphics, partialTicks);
        guiGraphics.method_27534(this.aetherFabric$getMinecraft().field_1772, this.getSelectedSkin().getDisplayName(), this.leftPos + this.imageWidth / 2, this.topPos + 12, 0xFFFFFF);
        guiGraphics.method_27534(this.aetherFabric$getMinecraft().field_1772, this.method_25440(), this.leftPos + this.imageWidth / 2, this.topPos - 15, 0xFFFFFF);
    }

    private void renderLifetimeIcon(class_332 guiGraphics, boolean mouseOver) {
        class_2960 location = PERMANENT_WIDGET.method_52729(true, mouseOver);
        guiGraphics.method_52706(location, this.leftPos + 13, this.topPos + this.imageHeight / 2 - 9, 8, 7);
    }

    private void renderPledgingIcon(class_332 guiGraphics, boolean mouseOver) {
        class_2960 location = TEMPORARY_WIDGET.method_52729(true, mouseOver);
        guiGraphics.method_52706(location, this.leftPos + 13, this.topPos + this.imageHeight / 2 - 9, 7, 7);
    }

    private boolean isMouseOverIcon(int mouseX, int mouseY, int width) {
        int leftPos = this.leftPos + 13;
        int topPos = this.topPos + this.imageHeight / 2 - 9;
        double mouseXDiff = mouseX - leftPos;
        double mouseYDiff = mouseY - topPos;
        return mouseYDiff <= 7.0 && mouseYDiff >= 0.0 && mouseXDiff <= (double)width && mouseXDiff >= 0.0;
    }

    private void renderTooltip(class_5250 title, class_2561 description, class_332 guiGraphics, int mouseX, int mouseY) {
        ArrayList<class_5250> formattedTextList = new ArrayList<class_5250>();
        formattedTextList.add(title.method_27692(class_124.field_1065));
        formattedTextList.addAll(this.aetherFabric$getMinecraft().field_1772.method_27527().method_27495((class_5348)description, this.field_22789 / 3, class_2583.field_24360));
        guiGraphics.method_51447(this.aetherFabric$getMinecraft().field_1772, class_2477.method_10517().method_30933(formattedTextList), mouseX, mouseY);
    }

    private void renderMoa(class_332 guiGraphics, float partialTicks) {
        if (this.aetherFabric$getMinecraft().field_1687 != null) {
            if (this.getPreviewMoa() == null) {
                Moa moa = (Moa)AetherEntityTypes.MOA.get().method_5883((class_1937)this.aetherFabric$getMinecraft().field_1687);
                if (moa != null) {
                    moa.generateMoaUUID();
                    moa.setMoaTypeByKey(AetherMoaTypes.BLUE);
                    moa.setSaddled(true);
                    this.previewMoa = moa;
                }
            } else {
                this.moaRotation = class_3532.method_15393((float)class_3532.method_16439((float)partialTicks, (float)this.moaRotation, (float)(this.moaRotation + 1.0f)));
                int startX = this.leftPos + this.imageWidth / 2;
                int startY = this.topPos + this.imageHeight / 2;
                MoaSkinsScreen.renderRotatingEntity(guiGraphics, startX - 300, startY - 135, startX + 300, startY + 65, 27, 0.055f, this.moaRotation, -20.0f, (class_1309)this.getPreviewMoa());
            }
        }
    }

    public static void renderRotatingEntity(class_332 guiGraphics, int startX, int startY, int endX, int endY, int scale, float yOffset, float angleXComponent, float angleYComponent, class_1309 livingEntity) {
        float posX = (float)(startX + endX) / 2.0f;
        float posY = (float)(startY + endY) / 2.0f;
        guiGraphics.method_44379(startX, startY, endX, endY);
        Quaternionf xQuaternion = new Quaternionf().rotateZ((float)Math.PI);
        Quaternionf zQuaternion = new Quaternionf().rotateX(angleYComponent * ((float)Math.PI / 180));
        xQuaternion.mul((Quaternionfc)zQuaternion);
        float yBodyRot = livingEntity.field_6283;
        float yRot = livingEntity.method_36454();
        float xRot = livingEntity.method_36455();
        livingEntity.method_5636(180.0f + angleXComponent);
        livingEntity.method_36456(180.0f + angleXComponent);
        livingEntity.method_36457(-angleYComponent);
        livingEntity.method_5847(livingEntity.method_36454());
        livingEntity.field_6259 = livingEntity.method_36454();
        Vector3f vector3f = new Vector3f(0.0f, livingEntity.method_17682() / 2.0f + yOffset, 0.0f);
        class_490.method_48472((class_332)guiGraphics, (float)posX, (float)posY, (float)scale, (Vector3f)vector3f, (Quaternionf)xQuaternion, (Quaternionf)zQuaternion, (class_1309)livingEntity);
        livingEntity.method_5636(yBodyRot);
        livingEntity.method_36456(yRot);
        livingEntity.method_36457(xRot);
        guiGraphics.method_44380();
    }

    private void checkUserConnectionStatus() {
        User user = UserData.Client.getClientUser();
        if (this.aetherFabric$getMinecraft().field_1724 != null) {
            if (user == null && this.userConnectionExists) {
                PacketDistributor.sendToServer(new ServerMoaSkinPacket.Remove(this.aetherFabric$getMinecraft().field_1724.method_5667()), new class_8710[0]);
                this.userConnectionExists = false;
            } else if (user != null && !this.userConnectionExists && MoaSkins.getMoaSkins().get(this.customizations.getMoaSkin()) != null) {
                PacketDistributor.sendToServer(new ServerMoaSkinPacket.Apply(this.aetherFabric$getMinecraft().field_1724.method_5667(), new MoaData(((AetherPlayerAttachment)this.aetherFabric$getMinecraft().field_1724.getAttachedOrCreate(AetherDataAttachments.AETHER_PLAYER)).getLastRiddenMoa(), MoaSkins.getMoaSkins().get(this.customizations.getMoaSkin()))), new class_8710[0]);
                this.userConnectionExists = true;
            }
        }
    }

    public boolean method_25403(double mouseX, double mouseY, int button, double dragX, double dragY) {
        if (button == 0) {
            float scrollbarGutterLeft = (float)this.leftPos + 7.0f;
            float f = this.topPos;
            Objects.requireNonNull(this);
            float scrollbarGutterTop = f + 184.0f / 2.0f + 29.0f;
            double mouseXDiff = mouseX - (double)scrollbarGutterLeft;
            double mouseYDiff = mouseY - (double)scrollbarGutterTop;
            if ((mouseYDiff <= 6.0 && mouseYDiff >= 0.0 || this.scrolling) && mouseXDiff <= 160.0 && mouseXDiff >= 0.0) {
                this.scrolling = true;
                this.scrollX = Math.max(0.0f, Math.min((float)mouseXDiff - this.scrollbarWidth() / 2.0f, this.scrollbarGutterWidth()));
                return true;
            }
        }
        return super.method_25403(mouseX, mouseY, button, dragX, dragY);
    }

    public boolean method_25401(double mouseX, double mouseY, double scrollX, double scrollY) {
        int i = 0;
        int index = this.getSlotOffset();
        if (index != -1) {
            i = index;
        }
        if (scrollY < 0.0) {
            i = Math.min(i + 1, this.snapPoints.size() - 1);
        } else if (scrollY > 0.0) {
            i = Math.max(i - 1, 0);
        }
        this.scrollX = this.snapPoints.get(i).floatValue();
        return true;
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        MoaSkins.MoaSkin skin = this.getSkinFromSlot(mouseX, mouseY);
        if (skin != null) {
            this.selectedSkin = skin;
            return true;
        }
        return super.method_25402(mouseX, mouseY, button);
    }

    @Nullable
    private MoaSkins.MoaSkin getSkinFromSlot(double mouseX, double mouseY) {
        int slot = this.getSlotIndex(mouseX, mouseY);
        if (slot != -1) {
            int trueSlot = slot + this.getSlotOffset();
            return this.moaSkins.get(trueSlot);
        }
        return null;
    }

    private int getSlotIndex(double mouseX, double mouseY) {
        int slotLeft = this.leftPos + 7;
        int slotTop = this.topPos + this.imageHeight / 2 + 9;
        double mouseXDiff = mouseX - (double)slotLeft;
        double mouseYDiff = mouseY - (double)slotTop;
        return mouseYDiff <= 18.0 && mouseYDiff >= 0.0 && mouseXDiff <= 160.0 && mouseXDiff >= 0.0 ? (int)(mouseXDiff / 18.0) : -1;
    }

    private int getSlotOffset() {
        int offset = 0;
        int index = this.snapPoints.indexOf(Float.valueOf(this.scrollX));
        if (index != -1) {
            offset = index;
        } else {
            for (int i = 0; i < this.snapPoints.size() - 1; ++i) {
                float nextPoint;
                float currentPoint = this.snapPoints.get(i).floatValue();
                float midway = currentPoint + ((nextPoint = this.snapPoints.get(i + 1).floatValue()) - currentPoint) / 2.0f;
                if (this.scrollX > midway && this.scrollX < nextPoint) {
                    offset = i + 1;
                    continue;
                }
                if (!(this.scrollX <= midway) || !(this.scrollX > currentPoint)) continue;
                offset = i;
            }
        }
        return offset;
    }

    public boolean method_25406(double mouseX, double mouseY, int button) {
        this.scrolling = false;
        return super.method_25406(mouseX, mouseY, button);
    }

    private float scrollbarWidth() {
        return 13.0f;
    }

    private float scrollbarGutterWidth() {
        return 160.0f - this.scrollbarWidth();
    }

    private int maxSlots() {
        return 9;
    }

    public void method_25419() {
        this.aetherFabric$getMinecraft().method_1507(this.lastScreen);
    }

    public boolean method_25421() {
        return false;
    }

    public MoaSkins.MoaSkin getSelectedSkin() {
        return this.selectedSkin;
    }

    public Moa getPreviewMoa() {
        return this.previewMoa;
    }
}

